/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Compile-time asserts.
 *
 ***************************************************************************/

#ifndef INC_CtAssert_hpp
#define INC_CtAssert_hpp



/**
 *  Compile-time assert. Expresions that can be evaluated at compile
 *  time can be tested using this assert.
 *
 *  Example:
 *      CT_ASSERT(sizeof(U16) == sizeof(U32), U32__not__compatible__with__U16);
 */
template<bool> struct CompileTimeError;
template<> struct CompileTimeError<true> {};

#define CT_ASSERT(expr, msg) \
    do { CompileTimeError<(expr)> ERROR_##msg; (void)ERROR_##msg; } while(false)



#endif // INC_CtAssert_hpp
