/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Definition of the function entry/exit tracing class.
 *
 ***************************************************************************/

#ifndef INC_FuncTrace_hpp
#define INC_FuncTrace_hpp


#include "NonCopyable.hpp"



class FuncTrace : private NonCopyable
{
  public:
    /**
     *  Constructor.
     * @param Specifies function name.
     */
    FuncTrace(char const * pFuncName);

    /**
     *  Destructor.
     */
    ~FuncTrace();

  private:
    /**
     *  Function name.
     */
    char const * const pFuncName_;
};



/**
 *  Function tracer.
 */
#if (DBG || defined(EVENT_TRACING))
#define FUNCTION_TRACE()        FuncTrace ft(OS_FUNCNAME)
#else
#define FUNCTION_TRACE()
#endif



#endif // INC_FuncTrace_hpp

