/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    OS independant spinlock definitions.
 *
 ***************************************************************************/

#ifndef INC_SpinLock_h
#define INC_SpinLock_h


#include "OsSpinLock.h"



/**
 *  Create a spinlock.
 * @param The spinlock parent object handle.
 * @return A handle to the new spinlock object.
 */
OsSpinLockHandle
OsSpinLockConstruct(
    OsObjectHandle hParent);


/**
 *  Acquire a spinlock.
 *  This function must be paired with OsSpinLockRelease.
 * @param A handle to an interrupt object.
 */
void
OsSpinLockAcquire(
    OsSpinLockHandle hLock);


/**
 *  Release a spinlock.
 *  This function must be paired with OsSpinLockAcquire.
 * @param A handle to an interrupt object.
 */
void
OsSpinLockRelease(
    OsSpinLockHandle hLock);


/**
 *  Destroy a specified spinlock object.
 * @param A spinlock handle.
 */
void
OsSpinLockDestruct(
    OsSpinLockHandle hLock);



#include "OsSpinLock_inline.h"



#endif // INC_SpinLock_h
