/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    OS dependant definitions.
 *
 ***************************************************************************/

#ifndef INC_Os_h
#define INC_Os_h

#ifdef __KERNEL__
#include <linux/fs.h>
#include <linux/cdev.h>
#include <linux/spinlock.h>
#include <linux/errno.h>        /* error numbers */
#include <linux/ioport.h>
#include <linux/interrupt.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#else
#include <sys/errno.h>
#endif

#include "OsTypes.h"


#define ASSERT(c)                                               \
    do                                                          \
    {                                                           \
        if (!(c))                                               \
        {                                                       \
            printk("ASSERT %s/%u\n", __FILE__, __LINE__);       \
        }                                                       \
    } while(0)

/**
 *  Inline specifier.
 */
#define OS_INLINE                   inline



/**
 *  Function name specifier.
 */
#define OS_FUNCNAME                 __FUNCTION__



/**
 *  Invalid handle.
 */
#define OS_INVALID_HANDLE           NULL 



/**
 *  Different OS status codes.
 */
typedef enum
{
    OS_STATUS__OK                  = 0,
    OS_STATUS__INVALID_IOCTL       = ENOTTY,
    OS_STATUS__INVALID_PARAMETER   = EINVAL,
    OS_STATUS__INVALID_RESOURCES   = EFAULT,
    OS_STATUS__NO_RESOURCES        = ENOMEM,
    OS_STATUS__OVERRUN             = EOVERFLOW,
    OS_STATUS__PENDING             = EBUSY,
    OS_STATUS__CANCELLED           = EAGAIN

} OsStatus;


/**
 *  General object handle.
 */
typedef void *                   OsObjectHandle;



/**
 *  Device handle.
 */
typedef struct cdev *             OsDeviceHandle;



/**
 *  Possible power device states.
 */
typedef enum
{
    OS_POWER_DEVICE_STATE__MIN          = 0,
    OS_POWER_DEVICE_STATE__D0           = 0,
    OS_POWER_DEVICE_STATE__D1           = 1,
    OS_POWER_DEVICE_STATE__D2           = 2,
    OS_POWER_DEVICE_STATE__D3           = 3,
    OS_POWER_DEVICE_STATE__D3_FINAL     = 4,
    OS_POWER_DEVICE_STATE__HIBERNATE    = 3,
    OS_POWER_DEVICE_STATE__MAX          = 5

} OsPowerDeviceState;






#if 0


/**
 *  Timer.
 *  WDF: OsTimerHandle     WDFTIMER*
 *       ParentObject (OS) WDFDEVICE
 */
typedef U32 TimeInMicroSeconds;

typedef void (*TimerCallback)(OsTimerContext);

OsTimerHandle
OsTimerConstruct(
    OsHandle           hOs,
    TimerCallback      pfCallback,
    TimeInMicroSeconds period);

void
OsTimerStart(
    OsTimerHandle      hTimer, 
    TimeInMicroSeconds time, 
    OsTimerContext     hContext);

void
OsTimerStop(
    OsTimerHandle hTimer,
    BOOLEAN       bWait);

void
OsTimerDestruct(
    OsTimerHandle hTimer);



/**
 *  Delay.
 */
void
OsDelaySuspend(
    TimeInMicroSeconds time);

void
OsDelayStall(
    TimeInMicroSeconds time);



/**
 *  Mutex.
 *  WDF: OsMutexHandle     WDFWAITLOCK*
 *       ParentObject (OS) WDFDEVICE
 */
OsMutexHandle
OsMutexConstruct(
    OsHandle hOs);

void
OsMutexAcquire(
    OsMutexHandle hMutex);

void
OsMutexRelease(
    OsMutexHandle hMutex);

void
OsMutexDestruct(
    OsMutexHandle hMutex);



/**
 *  Atomic.
 */
S32
OsAtomicAdd(
    S32 * const pAddend,
    S32         value);



/**
 *  Interrupt.
 *  WDF: OsInterruptHandle  WDFINTERRUPT (as passed in GpioCoreConstruct)
 *       OsInterruptContext WDFCONTEXT
 */
typedef void (*InterruptCallback)(OsInterruptContext);

BOOLEAN
OsInterruptSynchronize(
    OsInterruptHandle  hInterrupt,
    InterruptCallback  pfCallback,
    OsInterruptContext hContext);


#endif



#endif // INC_Os_h
