/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Linux alignment definition.
 *                  Include this if you want structs / etc
 *                  aligned in a particular fashion.
 *
 ***************************************************************************/
#ifndef INC_OsAlign_h
#define INC_OsAlign_h


#ifdef __KERNEL__
#define OS_ALIGN(alignment)         __attribute__(( aligned (alignment) ))
#define OS_GET_ALIGNMENT(a)         __alignof__(a)
#else
#define OS_ALIGN(alignment)
#define OS_GET_ALIGNMENT(a)
#endif

#endif // INC_OsAlign_h
