/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    OS dependant HW access definitions.
 *
 ***************************************************************************/

#ifndef INC_OsHwAccess_h
#define INC_OsHwAccess_h


#include "Os.h"


/**
 *  Partial HW resource descriptor.
 */
typedef struct _OsHwResource
{
	unsigned long           base ;       /* read/write[bwl] */

    unsigned long           length ;     // length of resource
    unsigned short          flags ;        
} OsHwResource ;



/**
 *  Device register base descriptor.
 */
typedef struct _OsRegBaseDescriptor
{
    OsHwResource     hwResource;

    void *           pBase;
    BOOLEAN          bMapped;

    // Speed up functions - I/O and memory space reads.
    U08 (*pfRead08)  (struct _OsRegBaseDescriptor const * const pRegBaseDescr,
                      size_t                                    offset);
    U16 (*pfRead16)  (struct _OsRegBaseDescriptor const * const pRegBaseDescr,
                      size_t                                    offset);
    U32 (*pfRead32)  (struct _OsRegBaseDescriptor const * const pRegBaseDescr,
                      size_t                                    offset);

    // Speed up functions - I/O and memory space writes.
    void (*pfWrite08) (struct _OsRegBaseDescriptor const * const pRegBaseDescr,
                      size_t                                     offset,
                      U08                                        value);
    void (*pfWrite16) (struct _OsRegBaseDescriptor const * const pRegBaseDescr,
                      size_t                                     offset,
                      U16                                        value);
    void (*pfWrite32) (struct _OsRegBaseDescriptor const * const pRegBaseDescr,
                      size_t                                     offset,
                      U32                                        value);

} OsRegBaseDescriptor;



#endif // INC_OsHwAccess_h
