/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    OS dependant interrupt inline functions.
 *
 ***************************************************************************/

#ifndef INC_OsInterrupt_inline_h
#define INC_OsInterrupt_inline_h


#include "OsInterrupt.h"

#include "DbgTrace.h"

/**
 *  Acquire an interrupt spinlock.
 *  This function changes the IRQL. It must be paired with
 *  OsInterruptReleaseLock in order to restore it.
 * @param A handle to an interrupt object.
 */
OS_INLINE extern void
OsInterruptAcquireLock(
    OsInterruptHandle hInterrupt)
{
    PATH_TESTED();
    PRECONDITION(hInterrupt->hLock != NULL);
    PRECONDITION(hInterrupt->flags == 0);

    spin_lock_irqsave(hInterrupt->hLock, hInterrupt->flags); 

}


/**
 *  Release an interrupt spinlock.
 *  This function changes the IRQL. It must be paired with
 *  OsInterruptAcquireLock in order to restore it.
 * @param A handle to an interrupt object.
 */
OS_INLINE extern void
OsInterruptReleaseLock(
    OsInterruptHandle hInterrupt)
{
    PATH_TESTED();
    
    spin_unlock_irqrestore(hInterrupt->hLock, hInterrupt->flags); 
    hInterrupt->flags = 0;
}

    


#endif // INC_OsInterrupt_inline_h
