/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    OS dependant I/O control definitions.
 *                  Linux alignment definition.
 *                  Include this if you want structs / etc
 *                  aligned in a particular fashion.
 *
 ***************************************************************************/

#ifndef INC_OsIoctl_h
#define INC_OsIoctl_h

#ifdef __KERNEL__
#include "Os.h"
#endif


typedef struct _IoctlHandle
{
    void *      pInputBuffer;
    size_t      inputLength;
    void *      pOutputBuffer;
    size_t      outputLength;
} IoctlHandle ;

#ifdef __KERNEL__
typedef struct _OsIoctlObject
{
    wait_queue_head_t *     pWqIoctl;
    
    int         osStatus;

    void *      pInputBuffer;
    void *      pOutputBuffer;
    
    IoctlHandle * pIoctlHandle ;
} OsIoctlObject ;


/**
 *  IOCTL request handle.
 */
typedef OsIoctlObject *                  OsIoctlHandle; 


/**
 *  IOCTL cancel callback function.
 */
typedef void *      OsIoctlCancelCallback;

#endif

#endif // INC_OsIoctl_h
