/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Implementation of OS dependant memory functions.
 *
 ***************************************************************************/

#include "Misc.h"
#include "OsMemory.h"
#include "DbgTrace.h"
#if defined(EVENT_TRACING)
/*
 *  The trace message header (.tmh) file must be included in a source file
 *  before any WPP macro calls and after defining a WPP_CONTROL_GUIDS
 *  macro (defined in trace.h). During the compilation, WPP scans the source
 *  files for DoTraceMessage() calls and builds a .tmh file which stores a unique
 *  data GUID for each message, the text resource string for each message,
 *  and the data types of the variables passed in for each message.
 *  This file is automatically generated and used during post-processing.
 */
#include "OsMemory.tmh"
#endif



/**
 *  Allocate a memory buffer.
 * @param Bytes to allocate.
 * @param Memory pool type.
 * @param Memory pool tag.
 * @return A memory buffer pointer on success or NULL otherwise.
 */
void *
OsMemoryBufferAllocate(
    size_t        size,
    OsMemoryType  type,
    OsMemoryTag   tag)
{
    void *pBuffer;

    OsDebugOutput(
        OS_LEVEL_VERBOSE, 
        OS_TRACE_FLAG_FUNC_TRACE, 
        "OsMemoryBufferAllocate\n");

    PATH_TESTED();

    PRECONDITION(size > 0);    
    
    pBuffer = kmalloc(size, type) ;
    
    return pBuffer;
}



/**
 *  Free a memory buffer.
 * @param A memory object buffer pointer.
 */
void
OsMemoryBufferFree(
    void * pBuffer)
{
    PATH_TESTED();

    PRECONDITION(pBuffer != NULL);
    
    kfree( pBuffer ) ;
}

