/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    OS dependant memory definitions.
 *
 ***************************************************************************/

#ifndef INC_OsMemory_h
#define INC_OsMemory_h


#include "Os.h"



/**
 *  Memory handle.
 */
typedef void *                          OsMemoryHandle;



/**
 *  Memory pool type.
 */
typedef enum
{
    OS_MEMORY_TYPE__NON_PAGED           = GFP_ATOMIC,
    OS_MEMORY_TYPE__PAGED               = GFP_KERNEL

} OsMemoryType;



/**
 *  Memory pool tag.
 */
typedef unsigned long                   OsMemoryTag;

/**
 *  Default memory pool tag, i.e. based on the driver name.
 */
#define OS_MEMORY_DEFAULT_TAG       0



#endif // INC_OsMemory_h
