/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    OS dependant spinlock inline functions.
 *
 ***************************************************************************/

#ifndef INC_OsSpinLock_inline_h
#define INC_OsSpinLock_inline_h


#include "OsSpinLock.h"



/**
 *  Acquire a spinlock.
 *  This function must be paired with OsSpinLockRelease.
 * @param A handle to an interrupt object.
 */
OS_INLINE extern void
OsSpinLockAcquire(
    OsSpinLockHandle hLock)
{
    PATH_TESTED();
    spin_lock_bh( hLock ) ;
}


/**
 *  Release a spinlock.
 *  This function must be paired with OsSpinLockAcquire.
 * @param A handle to an interrupt object.
 */
OS_INLINE extern void 
OsSpinLockRelease(
    OsSpinLockHandle hLock)
{
    PATH_TESTED();
    spin_unlock_bh( hLock ) ;
}


#endif // INC_OsSpinLock_inline_h
