/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Linux Type definitions.
 *
 ***************************************************************************/
#ifndef INC_OsTypes_h
#define INC_OsTypes_h

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <sys/types.h>
#endif


/**
 *  Byte, word, doubleword and quadword definitions.
 */
typedef unsigned char       U08;
typedef unsigned short      U16;
typedef unsigned int        U32;
typedef unsigned long long  U64;

/*
typedef u8       U08;
typedef u16      U16;
typedef u32      U32;
typedef u64      U64;
*/

/**
 *  I/O control code type.
 */
typedef unsigned int        OsIoControlCode;


#if (BITS_PER_LONG == 32)
#define UADDR U32
#else
#define UADDR U64
#endif

typedef unsigned char       BOOLEAN ;

#ifndef FALSE
#define FALSE               0
#endif

#ifndef TRUE
#define TRUE                (!FALSE)
#endif



#endif // INC_OsTypes_h
