/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Definition of the GPIO core structures.
 *
 ***************************************************************************/

#ifndef INC_GpioCoreDef_h
#define INC_GpioCoreDef_h

#include "Common.h"
#include "GpioCoreIoControls.h"



/**
 *  Max number of IOs.
 */
#define GPIO_MAX_NUMBER_OF_PINS 16



/**
 *  GPIO pin descriptor.
 */
typedef struct
{
    GpioPinMode                  pinMode;
    GpioInterruptAndWakeupMode   iwMode;
    GpioPwmTiming                pwmTiming;

} GpioPin;



/**
 *  GPIO related structure describing all GPIO HW asspects.
 */
typedef struct
{
    // Actual number of GPIO pins.
    GpioPinNumber               numberOfPins;

    // Keep a local copy of the config to avoid unnecessary HW reads.
    GpioPin                     aPin[GPIO_MAX_NUMBER_OF_PINS];

#if (GPIO_MAX_NUMBER_OF_PINS > 32)
#error "Too many GPIO pins defined"
#endif
    // More cached values.
    GpioPinMask                 inputMask;
    GpioPinMask                 outputMask;
    GpioPinMask                 outputDrainMask;
    GpioPinMask                 pwmOutputMask;

    GpioPinMask                 outputValues;

    // Enabled interrupts (no need to read HW registers).
    GpioPinMask                 interruptEnabledMask;
    // Pending interrupts (between ISR and DPC).
    GpioPinMask                 interruptPendingMask;

} GpioCoreHw;



/**
 *  GPIO related structure describing all GPIO OS related asspects.
 */
typedef struct
{
    // GpioCore parent device handle.
    OsDeviceHandle              hDevice;

    // Spin lock protecting DPC, IoctlCancel and IoctlDispatch.
    OsSpinLockHandle            hSpinLock;

    // Interrupt object's spinlock is used for synchronisation.
    OsInterruptHandle           hInterrupt;

    // Register base descriptor.
    OsRegBaseDescriptor         regBaseDescr;

    // IOCTL cancel callback function.
    OsIoctlCancelCallback       pfIoctlCancel;

    // Cancellable pending IOCTLs.
    OsIoctlHandle               ahPendingIoctl[GPIO_MAX_NUMBER_OF_PINS];

} GpioCoreOs;



/**
 *  Main GPIO structure describing all GPIO asspects.
 */
typedef struct
{
    GpioCoreHw                  hw;

    GpioCoreOs                  os;

    // HW state is to be retrieved when the device is
    // initialised for the first time.
    BOOLEAN                     bInitialStateObtained;

    // Have HW resources been assigned?
    BOOLEAN                     bHwResourcesAssigned;

} GpioCore;



#endif // INC_GpioCoreDef_h
